<?php
/**
 * Plugin Name:           AutomatorWP - Trello
 * Plugin URI:            https://automatorwp.com/add-ons/trello/
 * Description:           Connect AutomatorWP with Trello.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-trello
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Trello
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */ 

final class AutomatorWP_Trello {

    /**
     * @var         AutomatorWP_Trello $instance The one true AutomatorWP_Trello
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Trello self::$instance The one true AutomatorWP_Trello
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Trello();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_TRELLO_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_TRELLO_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_TRELLO_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_TRELLO_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/create-card.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/change-card-list.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/delete-card.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/change-desc.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/comment-card.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/add-label.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/add-member.php';
            require_once AUTOMATORWP_TRELLO_DIR . 'includes/actions/add-checklist-item.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'trello', array(
            'label' => 'Trello',
            'icon'  => AUTOMATORWP_TRELLO_URL . 'assets/trello.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Trello instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Trello The one true AutomatorWP_Trello
 */
function AutomatorWP_Trello() {
    return AutomatorWP_Trello::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Trello' );
