<?php
/**
 * Complete Module
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Triggers\Complete_Module
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Apprentice_Complete_Module extends AutomatorWP_Integration_Trigger {

    public $integration = 'thrive_apprentice';
    public $trigger = 'thrive_apprentice_complete_module';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User completes a module', 'automatorwp-pro' ),
            'select_option'     => __( 'User completes <strong>a module</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Module title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User completes %1$s %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Module title. */
            'log_label'         => sprintf( __( 'User completes %1$s', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'thrive_apprentice_module_finish',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Module:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any module', 'automatorwp-pro' ),
                    'post_type' => 'tva_module'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags( __( 'Module', 'automatorwp-pro' ) ),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param  array  	$module_details
     * @param  array  	$user_details
     */
    public function listener( $module_details, $user_details ) {

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_details['user_id'],
            'post_id'   => $module_details['module_id'],
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */

    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        
        // Don't deserve if post doesn't match with the trigger option
        if( automatorwp_posts_matches( $event['post_id'], $trigger_options['post'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_Thrive_Apprentice_Complete_Module();