<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Thrive_Apprentice\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting lessons
 *
 * @since 1.0.0
 */
function automatorwp_thrive_apprentice_ajax_get_lessons() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? sanitize_text_field( $_REQUEST['q'] ) : '';

    // Get course ID
    $course_id = isset( $_REQUEST['table'] ) ? sanitize_text_field( $_REQUEST['table'] ) : '';

    $lessons = automatorwp_thrive_apprentice_get_lessons( $course_id );

    // Parse lesson results to match select2 results
    foreach ( $lessons as $lesson ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $lesson['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $lesson['id'],
            'text' => $lesson['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_thrive_apprentice_get_lessons', 'automatorwp_thrive_apprentice_ajax_get_lessons' );

/**
 * Ajax function for selecting modules
 *
 * @since 1.0.0
 */
function automatorwp_thrive_apprentice_ajax_get_modules() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? sanitize_text_field( $_REQUEST['q'] ) : '';

    // Get course ID
    $course_id = isset( $_REQUEST['table'] ) ? sanitize_text_field( $_REQUEST['table'] ) : '';

    $modules = automatorwp_thrive_apprentice_get_modules( $course_id );

    // Parse module results to match select2 results
    foreach ( $modules as $module ) {

        if( ! empty( $search ) ) {
            if( strpos( strtolower( $module['name'] ), strtolower( $search ) ) === false ) {
                continue;
            }
        }
        
        $results[] = array(
            'id' => $module['id'],
            'text' => $module['name']
        );
    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_thrive_apprentice_get_modules', 'automatorwp_thrive_apprentice_ajax_get_modules' );