<?php
/**
 * Purchase Product
 *
 * @package     AutomatorWP\Integrations\SureCart\Triggers\Purchase_Product
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_SureCart_Purchase_Product extends AutomatorWP_Integration_Trigger {

    public $integration = 'surecart';
    public $trigger = 'surecart_purchase_product';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User purchases a product', 'automatorwp-pro' ),
            'select_option'     => __( 'User purchases <strong>a product</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Product title. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User purchases %1$s %2$s time(s)', 'automatorwp-pro' ), '{product}', '{times}' ),
            /* translators: %1$s: Product title. */
            'log_label'         => sprintf( __( 'User purchases %1$s', 'automatorwp-pro' ), '{product}' ),
            'action'            => 'surecart/purchase_created',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'product' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'product',
                    'name'              => __( 'Product:', 'automatorwp-pro' ),
                    'option_none_value' => 'any',
                    'option_none_label' => __( 'any product', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_surecart_get_products',
                    'options_cb'        => 'automatorwp_surecart_options_cb_product',
                    'default'           => 'any'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param array     $purchase
     * 
     */
    public function listener( $purchase ) {
        
        $user_id = get_current_user_id();

        // Bail if user is not logged
        if ($user_id === 0) {
            return;
        }

        $quantity = $purchase->quantity;

         // Trigger events same times as item quantity
        for ( $i = 0; $i < $quantity; $i++ ) {
        
            // Trigger user product purchased
            automatorwp_trigger_event( array(
                'trigger'       => $this->trigger,
                'user_id'       => $user_id,
                'order_id'      => $purchase->initial_order,
                'product_id'    => $purchase->product,
            ) );

        }
       
    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */


     public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['product_id'] ) ) {
            return false;
        }

        // Don't deserve if tag doesn't match with the trigger option
        if( $trigger_options['product'] !== 'any' && $trigger_options['product'] !== $event['product_id'] ) {
            return false;
        }

        return $deserves_trigger;

    }

}


new AutomatorWP_SureCart_Purchase_Product();