<?php
/**
 * Functions
 *
 * @package     AutomatorWP\SureCart\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get the products
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_surecart_get_products( ){

    $products = array();

    // Get the products
    $all_products = SureCart\Models\Product::get();
    
	foreach ( $all_products as $product ) {
		$products[] = array(
			'id' => $product->id,
			'name'  => $product->name,
		);
	}

	return $products;

}

/**
 * Options callback for select2 fields assigned to products
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_surecart_options_cb_product( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any product', 'automatorwp-pro' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $product_id ) {

            // Skip option none
            if( $product_id === $none_value ) {
                continue;
            }

            $options[$product_id] = automatorwp_surecart_get_product_title( $product_id );
        }
    }

    return $options;

}

/**
 * Get the product title
 *
 * @since 1.0.0
 *
 * @param int $product_id
 *
 * @return string|null
 */
function automatorwp_surecart_get_product_title( $product_id ) {

    // Empty title if no ID provided
    if( empty( $product_id ) ) {
        return '';
    }

    $all_products = SureCart\Models\Product::get();

	foreach ( $all_products as $product ) {

        if ( $product_id  ===  $product->id ) {
            $product_name = $product->name;
        }
		
	}

    return $product_name;

}