<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\SliceWP\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get the user's affiliate ID
 *
 * @since 1.0.0
 *
 * @param int $user_id
 *
 * @return bool|int
 */
function automatorwp_slicewp_get_user_affiliate_id( $user_id ) {

    if( $customer = slicewp_get_customer_by_user_id( $user_id ) ) {

        return absint( $customer->get( 'affiliate_id' ) );

    }

    return false;

}