<?php
/**
 * Add Commission To Affiliate
 *
 * @package     AutomatorWP\Integrations\SliceWP\Actions\Add_Commission_To_Affiliate
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_SliceWP_Add_Commission_To_Affiliate extends AutomatorWP_Integration_Action {

    public $integration = 'slicewp';
    public $action = 'slicewp_add_commission_to_affiliate';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add commission to user\'s affiliate', 'automatorwp-pro' ),
            'select_option'     => __( 'Add <strong>commission</strong> to user\'s affiliate', 'automatorwp-pro' ),
            /* translators: %1$s: Commission. */
            'edit_label'        => sprintf( __( 'Add %1$s to user\'s affiliate', 'automatorwp-pro' ), '{commission}' ),
            /* translators: %1$s: Commission. */
            'log_label'         => sprintf( __( 'Add %1$s to user\'s affiliate', 'automatorwp-pro' ), '{commission}' ),
            'options'           => array(
                'commission' => array(
                    'default' => __( 'commission', 'automatorwp-pro' ),
                    'fields' => array(
                        'reference' => array(
                            'name' => __( 'Reference:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                        'type' => array(
                            'name' => __( 'Type:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options_cb' => array( $this, 'commission_types_options_cb' ),
                            'default' => 'sale'
                        ),
                        'amount' => array(
                            'name' => __( 'Amount:', 'automatorwp-pro' ),
                            'type' => 'text',
                            'attributes' => array(
                                'type' => 'number'
                            ),
                            'default' => '0.00'
                        ),
                        'status' => array(
                            'name' => __( 'Status:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'pending'   => __( 'Pending', 'automatorwp-pro' ),
                                'paid'      => __( 'Paid', 'automatorwp-pro' ),
                                'unpaid'    => __( 'Unpaid', 'automatorwp-pro' ),
                                'rejected'  => __( 'Rejected', 'automatorwp-pro' ),
                            ),
                            'default' => 'pending'
                        ),
                        'commission_date' => array(
                            'name' => __( 'Date:', 'automatorwp-pro' ),
                            'desc' => __( 'Enter the commission date in format YYYY-MM-DD. Leave empty for the date of the moment the commission gets created.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                )
            ),
        ) );

    }

    /**
     * Get commission types options
     *
     * @since 1.0.0
     *
     * @return array
     */
    public function commission_types_options_cb() {

        $options = array();

        foreach( slicewp_get_commission_types() as $type_id => $type ) {
            $options[$type_id] = $type['label'];
        }

        return $options;

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $reference      = $action_options['reference'];
        $type           = $action_options['type'];
        $amount         = $action_options['amount'];
        $status         = $action_options['status'];
        $date           = $action_options['commission_date'];

        // Get the user's affiliate ID
        $affiliate_id = automatorwp_slicewp_get_user_affiliate_id( $user_id );

        // Bail since user has not an affiliate
        if( ! $affiliate_id ) {
            return;
        }

        // Prepare commission data
        $commission_data = array(
            'affiliate_id'  => $affiliate_id,
            'visit_id'		=> 0,
            'date_created'  => date( 'Y-m-d H:i:s', strtotime( $date ) ),
            'date_modified' => date( 'Y-m-d H:i:s', strtotime( $date ) ),
            'type'			=> $type,
            'status'		=> $status,
            'reference'     => $reference,
            'customer_id'	=> 0,
            'origin' 	    => 'automatorwp',
            'amount'		=> slicewp_sanitize_amount( $amount ),
            'currency'		=> slicewp_get_setting( 'active_currency', 'USD' )
        );

        // Insert the commission
        slicewp_insert_commission( $commission_data );

    }

}

new AutomatorWP_SliceWP_Add_Commission_To_Affiliate();