<?php
/**
 * Plugin Name:           AutomatorWP - Restrict Content
 * Plugin URI:            https://automatorwp.com/add-ons/restrict-content/
 * Description:           Manage access to any post or page through AutomatorWP.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-restrict-content
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.7
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Restrict Content
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Restrict_Content {

    /**
     * @var         AutomatorWP_Restrict_Content $instance The one true AutomatorWP_Restrict_Content
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Restrict_Content self::$instance The one true AutomatorWP_Restrict_Content
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Restrict_Content();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_RESTRICT_CONTENT_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_RESTRICT_CONTENT_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_RESTRICT_CONTENT_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_RESTRICT_CONTENT_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/content-filters.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/custom-tables.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/filters.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/access-levels.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/meta-boxes.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/post-functions.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/shortcodes.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/tags.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/users.php';

            // Triggers
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/triggers/all-users-access-level.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/triggers/access-level-added.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/triggers/access-level-removed.php';

            // Actions
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/actions/add-user-access-level.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/actions/remove-user-access-level.php';

            // Filters
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/filters/user-is-added-access-level.php';
            require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/filters/user-is-not-added-access-level.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Register this integration
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    public function register_integration() {

        // Register the integration
        automatorwp_register_integration( 'restrict_content', array(
            'label' => 'Restrict Content',
            'icon'  => AUTOMATORWP_RESTRICT_CONTENT_URL . 'assets/img/restrict-content.svg',
        ) );

        // Automations
        require_once AUTOMATORWP_RESTRICT_CONTENT_DIR . 'includes/automations/all-users-access-level.php';

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Restrict_Content instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Restrict_Content The one true AutomatorWP_Restrict_Content
 */
function AutomatorWP_Restrict_Content() {
    return AutomatorWP_Restrict_Content::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Restrict_Content' );
