<?php
/**
 * Users
 *
 * @package     AutomatorWP\Restrict Content\Users
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Display achievements for a user on their profile screen
 *
 * @since  1.0.0
 * @param  object $user The current user's $user object
 * @return void
 */
function automatorwp_restrict_content_user_profile_data( $user = null ) {

    if( ! current_user_can( automatorwp_get_manager_capability() ) ) {
        return;
    }

    $restrict_content = automatorwp_restrict_content_get_user_access_levels( $user->ID );
    $content = array();

    foreach( $restrict_content as $access_level ) {
        $content[] = '<a href="' . ct_get_edit_link( 'automatorwp_restrict_content_access_levels', $access_level->id ) . '" target="_blank">' . $access_level->name . '</a>';
    }
    ?>

    <h2><?php echo automatorwp_dashicon( 'lock' ); ?> <?php _e( 'Restrict Content', 'automatorwp-pro' ); ?></h2>

    <table class="form-table">
        <tbody>
            <tr>
                <th><label><?php _e( 'Access Levels:' ) ?></label></th>
                <td>
                    <?php echo implode( ', ', $content ); ?>
                </td>
            </tr>

        </tbody>

    </table>


    <?php



}
add_action( 'show_user_profile', 'automatorwp_restrict_content_user_profile_data' );
add_action( 'edit_user_profile', 'automatorwp_restrict_content_user_profile_data' );