<?php
/**
 * Restrict Content Shortcode
 *
 * @package     AutomatorWP\Restrict_Content\Shortcodes\Restrict_Content
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * [automatorwp_restrict_content]
 *
 * @since 1.0.0
 *
 * @param array     $atts       Shortcode's attributes
 * @param string    $content    Shortcode's content
 *
 * @return string
 */
function automatorwp_restrict_content_shortcode( $atts = array(), $content = '' ) {

    // Get the received shortcode attributes
    $atts = shortcode_atts( array(
        'access_level'  => '',
    ), $atts, 'automatorwp_restrict_content' );

    $slug = $atts['access_level'];
    $user_id = get_current_user_id();
    
    $access_level = automatorwp_restrict_content_get_access_level_by_slug( $slug );

    $output = '';

    // Check if user is in access level
    if( $access_level && automatorwp_restrict_content_is_user_on_access_level( $user_id, $access_level->id ) ) {
        $output = $content;

        // Execute shortcodes in content
        $output = do_shortcode( $output );

        // Execute blocks in content
        $output = do_blocks( $output );
    }

    /**
     * Filter to override shortcode output
     *
     * @since 1.0.0
     *
     * @param string    $output     Final output
     * @param array     $atts       Shortcode attributes
     * @param string    $content    Shortcode content
     */
    return apply_filters( 'automatorwp_restrict_content_shortcode_output', $output, $atts, $content );

}
add_shortcode( 'automatorwp_restrict_content', 'automatorwp_restrict_content_shortcode' );
add_shortcode( 'awp_rc', 'automatorwp_restrict_content_shortcode' );