<?php
/**
 * Send Friend Request
 *
 * @package     AutomatorWP\Integrations\PeepSo\Triggers\Send_Friend_Request
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_PeepSo_Send_Friend_Request extends AutomatorWP_Integration_Trigger {

    public $integration = 'peepso';
    public $trigger = 'peepso_send_friend_request';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User sends a friend request', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>sends</strong> a friend request', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User sends a friend request %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User sends a friend request', 'automatorwp-pro' ),
            'action'            => 'peepso_friends_requests_after_add',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $from_user_id Form user ID
     * @param int $to_user_id   To user ID
     */
    public function listener( $from_user_id, $to_user_id ) {

        // Trigger send friend request
        automatorwp_trigger_event( array(
            'trigger'           => $this->trigger,
            'user_id'           => $from_user_id,
            'to_user_id'        => $to_user_id,
        ) );

    }

}

new AutomatorWP_PeepSo_Send_Friend_Request();