<?php
/**
 * Plugin Name:           AutomatorWP - OpenAI
 * Plugin URI:            https://automatorwp.com/add-ons/openai/
 * Description:           Connect AutomatorWP with OpenAI.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-openai
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.5
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\OpenAI
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_OpenAI {

    /**
     * @var         AutomatorWP_OpenAI $instance The one true AutomatorWP_OpenAI
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_OpenAI self::$instance The one true AutomatorWP_OpenAI
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_OpenAI();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_OPENAI_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_OPENAI_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_OPENAI_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_OPENAI_URL', plugin_dir_url( __FILE__ ) );
    }


    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/scripts.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/tags.php';

            // Actions
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/correct-spelling-grammar.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-excerpt.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-image.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-seo-description.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-seo-title.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-text.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-translation.php';
            require_once AUTOMATORWP_OPENAI_DIR . 'includes/actions/generate-twitter.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        

    }

    
    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'openai', array(
            'label' => 'OpenAI',
            'icon'  => AUTOMATORWP_OPENAI_URL . 'assets/openai.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_OpenAI instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_OpenAI The one true AutomatorWP_OpenAI
 */
function AutomatorWP_OpenAI() {
    return AutomatorWP_OpenAI::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_OpenAI' );
