<?php
/**
 * Plugin Name:           AutomatorWP - Multimedia Content
 * Plugin URI:            https://automatorwp.com/add-ons/multimedia-content/
 * Description:           New triggers based on multimedia content creation and interaction.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-multimedia-content
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.6
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Multimedia_Content
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Multimedia_Content {

    /**
     * @var         AutomatorWP_Multimedia_Content $instance The one true AutomatorWP_Multimedia_Content
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Multimedia_Content self::$instance The one true AutomatorWP_Multimedia_Content
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Multimedia_Content();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_MULTIMEDIA_CONTENT_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_MULTIMEDIA_CONTENT_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_MULTIMEDIA_CONTENT_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_MULTIMEDIA_CONTENT_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/triggers/add-attachment.php';
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/triggers/watch-video.php';
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/triggers/get-watch-video.php';
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/triggers/listen-audio.php';
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/triggers/get-listen-audio.php';

            // Includes
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_MULTIMEDIA_CONTENT_DIR . 'includes/scripts.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Multimedia_Content instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Multimedia_Content The one true AutomatorWP_Multimedia_Content
 */
function AutomatorWP_Multimedia_Content() {
    return AutomatorWP_Multimedia_Content::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Multimedia_Content' );
