<?php
/**
 * Plugin Name:           AutomatorWP - Meta Box
 * Plugin URI:            https://automatorwp.com/add-ons/meta-box/
 * Description:           Connect AutomatorWP with Meta Box.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-meta-box
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.1
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Meta_Box
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Meta_Box {

    /**
     * @var         AutomatorWP_Meta_Box $instance The one true AutomatorWP_Meta_Box
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Meta_Box self::$instance The one true AutomatorWP_Meta_Box
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Meta_Box();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_META_BOX_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_META_BOX_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_META_BOX_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_META_BOX_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_META_BOX_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_META_BOX_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_META_BOX_DIR . 'includes/tags.php';

            // Triggers
            require_once AUTOMATORWP_META_BOX_DIR . 'includes/triggers/post-field-updated.php';

            // Actions
            require_once AUTOMATORWP_META_BOX_DIR . 'includes/actions/update-post-field.php';

            // Meta Box User Meta Extension
            if ( defined( 'MBAIO_DIR' ) || class_exists( 'RWMB_User_Storage' ) ) {

                // Triggers
                require_once AUTOMATORWP_META_BOX_DIR . 'includes/triggers/user-field-updated.php';

                // Actions
                require_once AUTOMATORWP_META_BOX_DIR . 'includes/actions/update-user-field.php';
                
            }
            

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'meta_box', array(
            'label' => 'Meta Box',
            'icon'  => AUTOMATORWP_META_BOX_URL . 'assets/meta-box.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'RW_Meta_Box' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Meta_Box instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Meta_Box The one true AutomatorWP_Meta_Box
 */
function AutomatorWP_Meta_Box() {
    return AutomatorWP_Meta_Box::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Meta_Box' );
