<?php
/**
 * Plugin Name:           AutomatorWP - Mautic
 * Plugin URI:            https://automatorwp.com/add-ons/mautic/
 * Description:           Connect AutomatorWP with Mautic.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-mautic
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Mautic
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Mautic {

    /**
     * @var         AutomatorWP_Mautic $instance The one true AutomatorWP_Mautic
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Mautic self::$instance The one true AutomatorWP_Mautic
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Mautic();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_MAUTIC_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_MAUTIC_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_MAUTIC_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_MAUTIC_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-user.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-user.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-user-segment.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-user-segment.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-user-company.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-user-company.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-contact.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-contact.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-contact-company.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-contact-company.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/add-contact-segment.php';
            require_once AUTOMATORWP_MAUTIC_DIR . 'includes/actions/remove-contact-segment.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'mautic', array(
            'label' => 'Mautic',
            'icon'  => AUTOMATORWP_MAUTIC_URL . 'assets/mautic.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Mautic instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Mautic The one true AutomatorWP_Mautic
 */
function AutomatorWP_Mautic() {
    return AutomatorWP_Mautic::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Mautic' );
