<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\Mautic\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_mautic_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-mautic-css', AUTOMATORWP_MAUTIC_URL . 'assets/css/automatorwp-mautic' . $suffix . '.css', array(), AUTOMATORWP_MAUTIC_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-mautic-js', AUTOMATORWP_MAUTIC_URL . 'assets/js/automatorwp-mautic' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_MAUTIC_VER, true );
    
}
add_action( 'admin_init', 'automatorwp_mautic_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_mautic_admin_enqueue_scripts( $hook ) {

    wp_enqueue_style( 'automatorwp-mautic-css' );

    wp_localize_script( 'automatorwp-mautic-js', 'automatorwp_mautic', array(
        'nonce' =>automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-mautic-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_mautic_admin_enqueue_scripts', 100 );
