<?php
/**
 * Reset Course Progress
 *
 * @package     AutomatorWP\Integrations\MasterStudy_LMS\Actions\Reset_Course_Progress
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_MasterStudy_LMS_Reset_Course_Progress extends AutomatorWP_Integration_Action {

    public $integration = 'masterstudy_lms';
    public $action = 'masterstudy_lms_reset_course_progress';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Reset the user\'s progress in a course', 'automatorwp-pro' ),
            'select_option'     => __( 'Reset the user\'s progress in a <strong>course</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Reset the user\'s progress in %1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Reset the user\'s progress in %1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Course:', 'automatorwp-pro' ),
                    'option_default'    => __( 'a course', 'automatorwp-pro' ),
                    'option_none'       => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                    'post_type'         => 'stm-courses',
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $course_id = absint( $action_options['post'] );

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        $curriculum = get_post_meta( $course_id, 'curriculum', true );

        // Bail course curriculum is empty
        if ( empty( $curriculum ) ) {
            return;
        }

        // Turn into an array of IDs
        $curriculum = STM_LMS_Helpers::only_array_numbers( explode( ',', $curriculum ) );

        $curriculum_posts = get_posts( array(
            'post__in'       => $curriculum,
            'posts_per_page' => 999,
            'post_type'      => array( 'stm-lessons', 'stm-quizzes', 'stm-assignments' ),
            'post_status'    => 'publish',
        ) );

        // Bail if no curriculum posts
        if ( empty( $curriculum_posts ) ) {
            return;
        }

        // Loop course items
        foreach ( $curriculum_posts as $post ) {

            switch( $post->post_type ) {
                case 'stm-lessons':
                    STM_LMS_User_Manager_Course_User::reset_lesson( $user_id, $course_id, $post->ID );
                    break;
                case 'stm-quizzes':
                    STM_LMS_User_Manager_Course_User::reset_quiz( $user_id, $course_id, $post->ID );
                    break;
                case 'stm-assignments':
                    STM_LMS_User_Manager_Course_User::reset_assignment( $user_id, $course_id, $post->ID );
                    break;
            }

        }

        STM_LMS_Course::update_course_progress( $user_id, $course_id );

    }

}

new AutomatorWP_MasterStudy_LMS_Reset_Course_Progress();