<?php
/**
 * Mark Quiz
 *
 * @package     AutomatorWP\Integrations\MasterStudy_LMS\Actions\Mark_Quiz
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_MasterStudy_LMS_Mark_Quiz extends AutomatorWP_Integration_Action {

    public $integration = 'masterstudy_lms';
    public $action = 'masterstudy_lms_mark_quiz';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark quiz as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>quiz as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => array(
                    'from' => 'post',
                    'default' => __( 'quiz', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                            'post_type'         => 'stm-courses',
                        ) ),
                        'course_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Course ID', 'automatorwp-pro' ),
                        ) ),
                        'post' => automatorwp_utilities_post_field( array(
                            'name'              => __( 'Quiz:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a quiz', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'option_custom'         => true,
                            'option_custom_desc'    => __( 'Quiz ID', 'automatorwp-pro' ),
                            'post_type'         => 'stm-quizzes',
                        ) ),
                        'post_custom' => automatorwp_utilities_custom_field( array(
                            'option_custom_desc'    => __( 'Quiz ID', 'automatorwp-pro' ),
                        ) ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $quiz_id = absint( $action_options['post'] );
        $course_id = absint( $action_options['course'] );

        // Bail if not quiz not provided
        if( $quiz_id === 0 ) {
            return;
        }

        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }

        // Bail if quiz already completed
        if ( STM_LMS_Quiz::quiz_passed( $quiz_id, $user_id ) ) {
            return;
        }

        $progress  = 100;
        $status    = 'passed';
        $user_quiz = compact( 'user_id', 'course_id', 'quiz_id', 'progress', 'status' );

        // Mark quiz as completed
        stm_lms_add_user_quiz( $user_quiz );
        stm_lms_get_delete_user_quiz_time( $user_id, $quiz_id );
        STM_LMS_Course::update_course_progress( $user_id, $course_id );

        $user_quiz['progress'] = round( $user_quiz['progress'], 1 );
        do_action( 'stm_lms_quiz_' . $status, $user_id, $quiz_id, $user_quiz['progress'] );

    }

}

new AutomatorWP_MasterStudy_LMS_Mark_Quiz();