<?php
/**
 * Plugin Name:           AutomatorWP - Mailchimp
 * Plugin URI:            https://automatorwp.com/add-ons/mailchimp/
 * Description:           Connect AutomatorWP with Mailchimp.
 * Version:               1.0.7
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-mailchimp
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Mailchimp
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Mailchimp {

    /**
     * @var         AutomatorWP_Mailchimp $instance The one true AutomatorWP_Mailchimp
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Mailchimp self::$instance The one true AutomatorWP_Mailchimp
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Mailchimp();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_MAILCHIMP_VER', '1.0.7' );

        // Plugin file
        define( 'AUTOMATORWP_MAILCHIMP_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_MAILCHIMP_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_MAILCHIMP_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/user-add-tag.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/user-remove-tag.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/user-subscribe.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/user-unsubscribe.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/user-add-note.php';

            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/contact-add-tag.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/contact-remove-tag.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/contact-subscribe.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/contact-unsubscribe.php';
            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/contact-add-note.php';

            require_once AUTOMATORWP_MAILCHIMP_DIR . 'includes/actions/create-send-campaign.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'mailchimp', array(
            'label' => 'Mailchimp',
            'icon'  => AUTOMATORWP_MAILCHIMP_URL . 'assets/mailchimp.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Mailchimp instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Mailchimp The one true AutomatorWP_Mailchimp
 */
function AutomatorWP_Mailchimp() {
    return AutomatorWP_Mailchimp::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Mailchimp' );
