<?php
/**
 * Reset Quiz
 *
 * @package     AutomatorWP\Integrations\LifterLMS\Actions\Reset_Quiz
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LifterLMS_Reset_Quiz extends AutomatorWP_Integration_Action {

    public $integration = 'lifterlms';
    public $action = 'lifterlms_reset_quiz';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Reset quiz attempts', 'automatorwp-pro' ),
            'select_option'     => __( 'Reset <strong>quiz attempts</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Reset %1$s attempts', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Reset %1$s attempts', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name'              => __( 'Quiz:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'all quizzes', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Quiz ID', 'automatorwp-pro' ),
                    'post_type'         => 'llms_quiz',
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $quiz_id = $action_options['post'];

        $student_attempts = new LLMS_Student_Quizzes( $user_id );

        // Check specific quiz
        if( $quiz_id !== 'any' ) {

            $attempts = $student_attempts->get_attempts_by_quiz( $quiz_id );

            // Bail if no attempts for this quiz
            if( empty( $attempts ) ) {
                return;
            }

        } else {

            // Get all user attempts
            $attempts = $student_attempts->get_all();

        }

        // Reset quizzes attempts
        if ( ! empty( $attempts ) ) {

            foreach ( $attempts as $attempt ) {
                // Delete attempt from database
                $attempt->delete();
            }

        }

    }

}

new AutomatorWP_LifterLMS_Reset_Quiz();