<?php
/**
 * Tags
 *
 * @package     AutomatorWP\LearnDash\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Essay tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_learndash_get_essay_tags() {

    return array(
        'essay_id' => array(
            'label'     => __( 'Essay ID', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The essay ID',
        ),
        'essay_title' => array(
            'label'     => __( 'Essay title', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The essay title',
        ),
        'essay_content' => array(
            'label'     => __( 'Essay content', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The essay content',
        ),
    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_learndash_get_trigger_essay_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'learndash' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'essay_id':
            $replacement = automatorwp_get_log_meta( $log->id, 'essay_id', true );
            break;
        case 'essay_title':
            $replacement = automatorwp_get_log_meta( $log->id, 'essay_title', true );
            break;
        case 'essay_content':
            $replacement = automatorwp_get_log_meta( $log->id, 'essay_content', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_learndash_get_trigger_essay_tag_replacement', 10, 6 );
