<?php
/**
 * User Is Added Group
 *
 * @package     AutomatorWP\Integrations\LearnDash\Filters\User_Is_Added_Group
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_LearnDash_User_Is_Added_Group_Filter extends AutomatorWP_Integration_Filter {

    public $integration = 'learndash';
    public $filter = 'learndash_user_is_added_group';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_filter( $this->filter, array(
            'integration'       => $this->integration,
            'label'             => __( 'User is in group', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>is in group</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Group. */
            'edit_label'        => sprintf( __( '%1$s', 'automatorwp-pro' ), '{post}'  ),
            /* translators: %1$s: Group. */
            'log_label'         => sprintf( __( '%1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Group:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any group', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Group ID', 'automatorwp-pro' ),
                    'post_type' => 'groups',
                    'default' => 'any'
                ) ),
            ),
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_filter    True if user deserves filter, false otherwise
     * @param stdClass  $filter             The filter object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $filter_options     The filter's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_filter( $deserves_filter, $filter, $user_id, $event, $filter_options, $automation ) {

        // Shorthand
        $group = $filter_options['post'];

        if ($group !== 'any') {
            $group_name = get_post($group)->post_title;
        } else{
            $group_name = 'any group';
        }
        
        // Bail if wrong configured
        if( empty( $group ) ) {
            $this->result = __( 'Filter not passed. Group option has not been configured.', 'automatorwp-pro' );
            return false;
        }

        // Get groups where the student is added
        $groups = learndash_get_users_group_ids( $user_id );

        // Don't deserve if user is not in this group
        if( ! in_array( $group, $groups ) ||  empty( $groups ) ) {
            $this->result = sprintf( __( 'Filter not passed. User is not in group "%1$s".', 'automatorwp-pro' ),
                $group_name
            );
            return false;
        }

        $this->result = sprintf( __( 'Filter passed. User is in group "%1$s".', 'automatorwp-pro' ),
            $group_name
        );

        return $deserves_filter;

    }

}

new AutomatorWP_LearnDash_User_Is_Added_Group_Filter();