<?php
/**
 * Tags
 *
 * @package     AutomatorWP\Jetpack_CRM\Tags
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Contact tags
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_jetpack_crm_get_contact_tags() {

    return array(
        'contact_first_name' => array(
            'label'     => __( 'Contact first name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The contact first name',
        ),
        'contact_last_name' => array(
            'label'     => __( 'Contact last name', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The contact last name',
        ),
        'contact_email' => array(
            'label'     => __( 'Contact email', 'automatorwp-pro' ),
            'type'      => 'text',
            'preview'   => 'The contact email',
        ),
    );

}

/**
 * Custom trigger tag replacement
 *
 * @since 1.0.0
 *
 * @param string    $replacement    The tag replacement
 * @param string    $tag_name       The tag name (without "{}")
 * @param stdClass  $trigger        The trigger object
 * @param int       $user_id        The user ID
 * @param string    $content        The content to parse
 * @param stdClass  $log            The last trigger log object
 *
 * @return string
 */
function automatorwp_jetpack_crm_get_trigger_contact_tag_replacement( $replacement, $tag_name, $trigger, $user_id, $content, $log ) {


    $trigger_args = automatorwp_get_trigger( $trigger->type );

    // Skip if trigger is not from this integration
    if( $trigger_args['integration'] !== 'jetpack_crm' ) {
        return $replacement;
    }

    switch( $tag_name ) {
        case 'contact_first_name':
            $replacement = automatorwp_get_log_meta( $log->id, 'contact_first_name', true );
            break;
        case 'contact_last_name':
            $replacement = automatorwp_get_log_meta( $log->id, 'contact_last_name', true );
            break;
        case 'contact_email':
            $replacement = automatorwp_get_log_meta( $log->id, 'contact_email', true );
            break;
    }

    return $replacement;

}
add_filter( 'automatorwp_get_trigger_tag_replacement', 'automatorwp_jetpack_crm_get_trigger_contact_tag_replacement', 10, 6 );

