<?php
/**
 * Accept Invite
 *
 * @package     AutomatorWP\Integrations\Invite_Anyone\Triggers\Accept_Invite
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Invite_Anyone_Accept_Invite extends AutomatorWP_Integration_Trigger {

    public $integration = 'invite_anyone';
    public $trigger = 'invite_anyone_accept_invite';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User accepts an invitation', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>accepts</strong> an invitation', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User accepts an invitation %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User accepts an invitation', 'automatorwp-pro' ),
            'action'            => 'automatorwp_invite_anyone_invite_accepted',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int       $user_id
     * @param int       $inviter_id
     */
    public function listener( $user_id, $inviter_id ) {

        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
        ) );

    }

}

new AutomatorWP_Invite_Anyone_Accept_Invite();