<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\Instagram\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Create container
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_instagram_create_container( $image_url, $caption ) {

    $container = array();

    $params = automatorwp_instagram_get_request_parameters( );

    // Bail if the authorization has not been setup from settings
    if( $params === false ) {
        return $container;
    }

    $auth = get_option( 'automatorwp_instagram_auth', false );
	
    $access_token = $auth['access_token'];
    $ig_user_id = automatorwp_instagram_get_option( 'ig_id', '' );

    $url = 'https://graph.instagram.com/v23.0/' . $ig_user_id . '/media';

	$response = wp_remote_post( $url, array(
        'headers' => array(
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token,
            'Content-Type'  => 'application/json'
        ),
        'body' => json_encode( array(
            "image_url"   => $image_url,
            "caption"     => $caption,
        ) )
    ));

    if (is_wp_error($response)) {
        return;
    }

    $result = json_decode( wp_remote_retrieve_body( $response ), true );
    
    return $result;
}

/**
 * Create container
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_instagram_publish_post( $container_id ) {

    if ( empty( $container_id) ) {
        return false;
    }

    $result = array();

    $params = automatorwp_instagram_get_request_parameters( );

    // Bail if the authorization has not been setup from settings
    if( $params === false ) {
        return $result;
    }

    $auth = get_option( 'automatorwp_instagram_auth', false );
	
    $access_token = $auth['access_token'];
    $ig_user_id = automatorwp_instagram_get_option( 'ig_id', '' );

    $url = 'https://graph.instagram.com/v23.0/' . $ig_user_id . '/media_publish';

	$response = wp_remote_post( $url, array(
        'headers' => array(
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $access_token,
            'Content-Type'  => 'application/json'
        ),
        'body' => json_encode( array(
            "creation_id"   => $container_id,
        ) )
    ));
	
    if (is_wp_error($response)) {
        return;
    }

    $result = json_decode( wp_remote_retrieve_body( $response ), true );
    
    return $result;
}

/**
 * Get the request parameters
 *
 * @since 1.0.0
 *
 * @param string $platform
 *
 * @return array|false
 */
function automatorwp_instagram_get_request_parameters( ) {

    $auth = get_option( 'automatorwp_instagram_auth' );
    
    if( ! is_array( $auth ) ) {
        return false;
    }

    return array(
        'user-agent'  => 'AutomatorWP; ' . home_url(),
        'timeout'     => 120,
        'httpversion' => '1.1',
        'headers'     => array(
            'Authorization' => 'Bearer ' . $auth['access_token'],
            'Content-Type'  => 'application/json',
            'Accept'        => 'application/json'
        )
    );
}
