<?php
/**
 * Admin
 *
 * @package     AutomatorWP\Integrations\HubSpot\Admin
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Shortcut function to get plugin options
 *
 * @since  1.0.0
 *
 * @param string    $option_name
 * @param bool      $default
 *
 * @return mixed
 */
function automatorwp_hubspot_get_option( $option_name, $default = false ) {

    $prefix = 'automatorwp_hubspot_';

    return automatorwp_get_option( $prefix . $option_name, $default );
}

/**
 * Register plugin settings sections
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_hubspot_settings_sections( $automatorwp_settings_sections ) {

    $automatorwp_settings_sections['hubspot'] = array(
        'title' => __( 'HubSpot', 'automatorwp-pro' ),
        'icon' => 'dashicons-hubspot',
    );

    return $automatorwp_settings_sections;

}
add_filter( 'automatorwp_settings_sections', 'automatorwp_hubspot_settings_sections' );

/**
 * Register plugin settings meta boxes
 *
 * @since  1.0.0
 *
 * @return array
 */
function automatorwp_hubspot_settings_meta_boxes( $meta_boxes )  {

    $prefix = 'automatorwp_hubspot_';

    $meta_boxes['automatorwp-hubspot-settings'] = array(
        'title' => automatorwp_dashicon( 'hubspot' ) . __( 'HubSpot', 'automatorwp-pro' ),
        'fields' => apply_filters( 'automatorwp_hubspot_settings_fields', array(
            $prefix . 'authorize' => array(
                'type' => 'text',
                'render_row_cb' => 'automatorwp_hubspot_authorize_display_cb',
            ),
        ) ),
    );

    return $meta_boxes;

}
add_filter( "automatorwp_settings_hubspot_meta_boxes", 'automatorwp_hubspot_settings_meta_boxes' );

/**
 * Display callback for the authorize setting
 *
 * @since  1.0.0
 */
function automatorwp_hubspot_authorize_display_cb() {

    $admin_url = str_replace( 'http://', 'http://', get_admin_url() )  . 'admin.php?page=automatorwp_settings&tab=opt-tab-hubspot';
    $access_token = get_option( 'automatorwp_hubspot_access_token' );
    $refresh_token = get_option( 'automatorwp_hubspot_refresh_token' );
    $oauth_url = 'https://app.hubspot.com/oauth/authorize?'
        . 'redirect_uri=' . urlencode( $admin_url )
        . '&client_id=' . AUTOMATORWP_HUBSPOT_CLIENT_ID
        . '&scope=oauth%20crm.lists.read%20crm.objects.contacts.read%20crm.objects.contacts.write%20crm.objects.companies.write%20crm.schemas.contacts.read%20crm.lists.write%20crm.objects.companies.read%20crm.schemas.companies.read%20crm.schemas.companies.write%20crm.schemas.contacts.write';
    ?>
    <div class="cmb-row cmb-type-custom cmb2-id-automatorwp-hubspot-authorize table-layout" data-fieldtype="custom">
        <div class="cmb-th">
            <label><?php echo __( 'Connect with HubSpot:', 'automatorwp-pro' ); ?></label>
        </div>
        <div class="cmb-td">
            <a class="button button-primary" href="<?php echo $oauth_url; ?>"><?php echo __( 'Authorize', 'automatorwp-pro' ); ?></a>
            <p class="cmb2-metabox-description"><?php echo __( 'Click on "Authorize" button to authorize AutomatorWP and generate access keys for this site.', 'automatorwp-pro' ); ?></p>
            <?php if ( $access_token !== false &&  $refresh_token !== false ) : ?>
                <div class="automatorwp-notice-success"><?php echo __( 'Site connected with HubSpot successfully.', 'automatorwp-pro' ); ?></div>
                <p class="automatorwp-hubspot-access-token"><strong><?php echo __( 'Access token:', 'automatorwp-pro' ); ?></strong> <input type="text" value="<?php echo $access_token; ?>" readonly></p>
                <p class="automatorwp-hubspot-refresh-token"><strong><?php echo __( 'Refresh token:', 'automatorwp-pro' ); ?></strong> <input type="text" value="<?php echo $refresh_token; ?>" readonly></p>
            <?php endif; ?>
        </div>
    </div>
    <?php
}

/**
 * Check if authorization process has been completed
 *
 * @since  1.0.0
 */
function automatorwp_hubspot_maybe_authorize_complete() {

    if( isset( $_GET['code'] )
        && isset( $_GET['page'] ) && $_GET['page'] == 'automatorwp_settings'
        && isset( $_GET['tab'] ) && $_GET['tab'] == 'opt-tab-hubspot' ) {

        $params = array(
            'body'	=> array(
                'grant_type'	=> 'authorization_code',
                'client_id'		=> AUTOMATORWP_HUBSPOT_CLIENT_ID,
                'client_secret' => AUTOMATORWP_HUBSPOT_CLIENT_SECRET,
                'redirect_uri'	=> str_replace( 'http://', 'http://', get_admin_url() ) . 'admin.php?page=automatorwp_settings&tab=opt-tab-hubspot',
                'code'			=> $_GET['code']
            )
        );

        $response = wp_remote_post( 'https://api.hubapi.com/oauth/v1/token', $params );

        // Bail if can't contact with the server
        if ( is_wp_error( $response ) ) {
            return;
        }

        $body = json_decode( wp_remote_retrieve_body( $response ) );
error_log(print_r($body, 1));
        // Bail on receive an error
        if( isset( $body->error ) ) {
            return;
        }

        // Update the access and refresh tokens
        update_option( 'automatorwp_hubspot_access_token', $body->access_token );
        update_option( 'automatorwp_hubspot_refresh_token', $body->refresh_token );

        // Redirect to settings again
        wp_redirect( get_admin_url() . 'admin.php?page=automatorwp_settings&tab=opt-tab-hubspot' );
        exit;

    }

}
add_action( 'admin_init', 'automatorwp_hubspot_maybe_authorize_complete' );