<?php
/**
 * Plugin Name:           AutomatorWP - HubSpot
 * Plugin URI:            https://automatorwp.com/add-ons/hubspot/
 * Description:           Connect AutomatorWP with HubSpot.
 * Version:               1.0.3
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-hubspot
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.2
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\HubSpot
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_HubSpot {

    /**
     * @var         AutomatorWP_HubSpot $instance The one true AutomatorWP_HubSpot
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_HubSpot self::$instance The one true AutomatorWP_HubSpot
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_HubSpot();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_HUBSPOT_VER', '1.0.3' );

        // Plugin file
        define( 'AUTOMATORWP_HUBSPOT_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_HUBSPOT_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_HUBSPOT_URL', plugin_dir_url( __FILE__ ) );

        // HubSpot App
        define( 'AUTOMATORWP_HUBSPOT_APP_ID', 233962 );
        define( 'AUTOMATORWP_HUBSPOT_CLIENT_ID', '80771514-ece4-42a4-a4d7-c9694af6bf83' );
        define( 'AUTOMATORWP_HUBSPOT_CLIENT_SECRET', '5f636594-8cc2-49f2-87b6-8e7e1db8321c' );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/actions/create-contact.php';
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/actions/user-list.php';
            require_once AUTOMATORWP_HUBSPOT_DIR . 'includes/actions/update-contact.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'hubspot', array(
            'label' => 'HubSpot',
            'icon'  => AUTOMATORWP_HUBSPOT_URL . 'assets/hubspot.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_HubSpot instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_HubSpot The one true AutomatorWP_HubSpot
 */
function AutomatorWP_HubSpot() {
    return AutomatorWP_HubSpot::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_HubSpot' );
