<?php
/**
 * User Tag
 *
 * @package     AutomatorWP\Integrations\Groundhogg\Actions\User_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Groundhogg_User_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'groundhogg';
    public $action = 'groundhogg_user_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to user', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to user', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. */
            'edit_label'        => sprintf( __( '%1$s tag %2$s', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. */
            'log_label'         => sprintf( __( '%1$s tag %2$s', 'automatorwp-pro' ), '{operation}', '{tag}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'tag',
                    'option_default'    => __( 'Select a tag', 'automatorwp-pro' ),
                    'name'              => __( 'Tag:', 'automatorwp-pro' ),
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Tag ID', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_groundhogg_get_tags',
                    'options_cb'        => 'automatorwp_groundhogg_options_cb_tag',
                    'default'           => ''
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $tag_id = $action_options['tag'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Bail if empty tag to assign
        if( empty( $tag_id ) ) {
            return;
        }

        $tag = Groundhogg\Plugin::$instance->dbs->get_db( 'tags' )->get( $tag_id );

        // Bail if tag not exists
        if( ! $tag ) {
            return;
        }

        $contact = new Groundhogg\Contact( $user_id, true );

        if( ! $contact ) {
            return;
        }

        switch ( $operation ) {
            case 'add':
                // Add tag to the user
                $contact->add_tag( $tag->tag_id );
                break;
            case 'remove':
                // Remove tag to the user
                $contact->remove_tag( $tag->tag_id );
                break;
        }


    }

}

new AutomatorWP_Groundhogg_User_Tag();