<?php
/**
 * Create Contact Note
 *
 * @package     AutomatorWP\Integrations\Groundhogg\Actions\Create_Contact_Note
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.5
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Groundhogg_Create_Contact_Note extends AutomatorWP_Integration_Action {

    public $integration = 'groundhogg';
    public $action = 'groundhogg_create_contact_note';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Create note and assign to contact', 'automatorwp-pro' ),
            'select_option'     => __( 'Create <strong>note</strong> and assign to <strong>contact</strong>', 'automatorwp-pro' ),
            /* %1$s: Note. %2$s: Contact. */
            'edit_label'        => sprintf( __( 'Create %1$s and assign to %2$s', 'automatorwp-pro' ), '{note}', '{contact}' ),
            /* %1$s: Note. %2$s: Contact. */
            'log_label'         => sprintf( __( 'Create %1$s and assign to %2$s', 'automatorwp-pro' ), '{note}', '{contact}' ),
            'options'           => array(
                'note' => array(
                    'default' => __( 'Note', 'automatorwp-pro' ),
                    'fields' => array(
                        'note' => array(
                            'name' => __( 'Note:', 'automatorwp-pro' ),
                            'desc' => __( 'The note to add', 'automatorwp-pro' ),
                            'type' => 'wysiwyg',
                            'required'  => true,
                            'default' => ''
                        ),
                    ) ),
                'contact' => array(
                    'from' => 'contact',
                    'default' => __( 'contact', 'automatorwp-pro' ),
                    'fields' => array(
                        'contact' => array(
                            'name' => __( 'Contact Email:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $note = $action_options['note'];
        $contact = $action_options['contact'];

        // Bail if empty tag to assign
        if( empty( $note ) ) {
            return;
        }

        $note = wp_kses_post( $note );

        $contact = new Groundhogg\Contact( $contact, true );

        if( ! $contact ) {
            return;
        }

        // Add note to the user
        $contact->add_note( $note );

    }

}

new AutomatorWP_Groundhogg_Create_Contact_Note();