<?php
/**
 * Plugin Name:           AutomatorWP - Google Calendar
 * Plugin URI:            https://automatorwp.com/add-ons/google-calendar/
 * Description:           Connect AutomatorWP with Google Calendar.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-google-calendar
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.5
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Google_Calendar
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Google_Calendar {

    /**
     * @var         AutomatorWP_Google_Calendar $instance The one true AutomatorWP_Google_Calendar
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Google_Calendar self::$instance The one true AutomatorWP_Google_Calendar
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Google_Calendar();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_GOOGLE_CALENDAR_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_GOOGLE_CALENDAR_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_GOOGLE_CALENDAR_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_GOOGLE_CALENDAR_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/actions/add-event.php';
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/actions/add-attendee.php';
            require_once AUTOMATORWP_GOOGLE_CALENDAR_DIR . 'includes/actions/remove-attendee.php';



        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'google_calendar', array(
            'label' => 'Google Calendar',
            'icon'  => AUTOMATORWP_GOOGLE_CALENDAR_URL . 'assets/google-calendar.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Google_Calendar instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Google_Calendar The one true AutomatorWP_Google_Calendar
 */
function AutomatorWP_Google_Calendar() {
    return AutomatorWP_Google_Calendar::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Google_Calendar' );
