<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Generator\Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get the tags
 *
 * @since 1.0.0
 *
 * @return string
 */
function automatorwp_generator_random_string( $length, $allowed_characters ) {
    
    $characters = '';

    // Lowercase
    if( in_array( 'lowercase', $allowed_characters ) ) {
        $characters = $characters . 'abcdefghijklmnopqrstuvwxyz';
    }
    
    // Uppercase
    if( in_array( 'uppercase', $allowed_characters ) ) {
        $characters = $characters . 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    }
    
    // Special characters
    if( in_array( 'special', $allowed_characters ) ) {
        $characters = $characters . '!#$%&()*+,-./:;<=>?@[\]^_`|~';
    }

    // Numbers
    if( in_array( 'number', $allowed_characters ) ) {
        $characters = $characters . '0123456789';
    }

    if( empty( $characters ) ) {
        $characters = $characters . 'abcdefghijklmnopqrstuvwxyz';
    }

    $random_string = substr( str_shuffle( str_repeat( $characters, ceil( $length / strlen( $characters ) ) ) ), 1, $length );

    return $random_string;
    
}

/**
 * Get the algorithms
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_generator_get_algorithms( ) {

    return hash_algos();
}