<?php
/**
 * Award Points
 *
 * @package     AutomatorWP\Integrations\GamiPress\Actions\Award_Points
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_GamiPress_Award_Points extends AutomatorWP_Integration_Action {

    public $integration = 'gamipress';
    public $action = 'gamipress_award_points';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Award points', 'automatorwp-pro' ),
            'select_option'     => __( 'Award <strong>points</strong>', 'automatorwp-pro' ),
            /* translators: %1$s; Points amount. %2$s: Post title. */
            'edit_label'        => sprintf( __( 'Award %1$s %2$s', 'automatorwp-pro' ), '{points}', '{post}' ),
            /* translators: %1$s; Points amount. %2$s: Post title. */
            'log_label'         => sprintf( __( 'Award %1$s %2$s', 'automatorwp-pro' ), '{points}', '{post}' ),
            'options'           => array(
                'points' => array(
                    'from' => 'points',
                    'fields' => array(
                        'points' => array(
                            'name' => __( 'Points amount:', 'automatorwp' ),
                            'type' => 'text',
                            'attributes' => array(
                                'type' => 'number',
                                'min' => '1',
                            ),
                            'default' => 1
                        )
                    )
                ),
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Points type:', 'automatorwp-pro' ),
                    'option_default' => __( 'Select a points type', 'automatorwp-pro' ),
                    'option_none' => false,
                    'post_type' => 'points-type'
                ) ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $points = absint( $action_options['points'] );
        $post_id = absint( $action_options['post'] );

        // Bail if no points to award
        if( $points === 0 ) {
            return;
        }

        $post = get_post( $post_id );

        // Bail if post doesn't exists
        if( ! $post ) {
            return;
        }

        // Bail if post is not a points type
        if( $post->post_type !== 'points-type' ) {
            return;
        }

        // Award the points
        gamipress_award_points_to_user( $user_id, $points, $post->post_name );

    }

}

new AutomatorWP_GamiPress_Award_Points();