<?php
/**
 * Plugin Name:           AutomatorWP - Facebook
 * Plugin URI:            https://automatorwp.com/add-ons/facebook/
 * Description:           Connect AutomatorWP with Facebook.
 * Version:               1.0.2
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-facebook
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.3
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Facebook
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Facebook {

    /**
     * @var         AutomatorWP_Facebook $instance The one true AutomatorWP_Facebook
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Facebook self::$instance The one true AutomatorWP_Facebook
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Facebook();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_FACEBOOK_VER', '1.0.2' );

        // Plugin file
        define( 'AUTOMATORWP_FACEBOOK_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_FACEBOOK_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_FACEBOOK_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/admin.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/ajax-functions.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/functions.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/scripts.php';

            // Actions
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-post-page.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-link-page.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-image-page.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-post-group.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-link-group.php';
            require_once AUTOMATORWP_FACEBOOK_DIR . 'includes/actions/publish-image-group.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'facebook', array(
            'label' => 'Facebook',
            'icon'  => AUTOMATORWP_FACEBOOK_URL . 'assets/facebook.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Facebook instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Facebook The one true AutomatorWP_Facebook
 */
function AutomatorWP_Facebook() {
    return AutomatorWP_Facebook::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Facebook' );
