<?php
/**
 * Plugin Name:           AutomatorWP - Everest Forms
 * Plugin URI:            https://automatorwp.com/add-ons/everest-forms/
 * Description:           Connect AutomatorWP with Everest Forms
 * Version:               1.0.1
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-everest-forms
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.8
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\EverestForms
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_EverestForms {

    /**
     * @var         AutomatorWP_EverestForms $instance The one true AutomatorWP_EverestForms
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_EverestForms self::$instance The one true AutomatorWP_EverestForms
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_EverestForms();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }


    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_EVERESTFORMS_VER', '1.0.1' );

        // Plugin file
        define( 'AUTOMATORWP_EVERESTFORMS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_EVERESTFORMS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_EVERESTFORMS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_EVERESTFORMS_DIR . 'includes/functions.php';

            // Triggers
            require_once AUTOMATORWP_EVERESTFORMS_DIR . 'includes/triggers/submit-form.php';
            require_once AUTOMATORWP_EVERESTFORMS_DIR . 'includes/triggers/submit-field-value.php';
            
            //Anonymous Triggers
            require_once AUTOMATORWP_EVERESTFORMS_DIR . 'includes/triggers/anonymous-submit-form.php';
            require_once AUTOMATORWP_EVERESTFORMS_DIR . 'includes/triggers/anonymous-submit-field-value.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'everest_forms', array(
            'label' => 'Everest Forms',
            'icon'  => AUTOMATORWP_EVERESTFORMS_URL . 'assets/everest-forms.svg',
        ) );

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */


    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'EverestForms' ) ) {
            
            return false;
        }

        return true;

    }    


}

/**
 * The main function responsible for returning the one true AutomatorWP_EverestForms instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_EverestForms The one true AutomatorWP_EverestForms
 */
function AutomatorWP_EverestForms() {
    return AutomatorWP_EverestForms::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_EverestForms' );
