<?php
/**
 * Update Event
 *
 * @package     AutomatorWP\Integrations\Eventin\Triggers\Update_Event
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Eventin_Update_Event extends AutomatorWP_Integration_Trigger {

    public $integration = 'eventin';
    public $trigger = 'eventin_update_event';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User updates an event', 'automatorwp-pro' ),
            'select_option'     => __( 'User updates an <strong>event</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Event. %2$s: Number of times. */
            'edit_label'        => sprintf( __( 'User updates %1$s %2$s time(s)', 'automatorwp-pro' ), '{post}', '{times}' ),
            /* translators: %1$s: Event. */
            'log_label'         => sprintf( __( 'User updates %1$s', 'automatorwp-pro' ), '{post}' ),
            'action'            => 'eventin_event_updated',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Event:', 'automatorwp' ),
                    'option_none_label' => __( 'any event', 'automatorwp' ),
                    'post_type' => 'etn'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_post_tags(),
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param Event_Model       $event    Event data
     */
    public function listener( $event ) {
    
        $user_id = get_current_user_id( );

        // Bail if user is not logged
        if ( $user_id === 0 ){
            return;
        }

        // Trigger update event
        automatorwp_trigger_event( array(
            'trigger'   => $this->trigger,
            'user_id'   => $user_id,
            'post_id'   => $event->id,
        ) );
       
    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_trigger   True if user deserves trigger, false otherwise
     * @param stdClass  $trigger            The trigger object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $trigger_options    The trigger's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_trigger( $deserves_trigger, $trigger, $user_id, $event, $trigger_options, $automation ) {

        // Don't deserve if post is not received
        if( ! isset( $event['post_id'] ) ) {
            return false;
        }

        // Don't deserve if post doesn't match with the trigger option
        if( $trigger_options['post'] !== 'any' && absint( $trigger_options['post'] ) !== absint( $event['post_id'] ) ) {
            return false;
        }

        return $deserves_trigger;

    }

}

new AutomatorWP_Eventin_Update_Event();