<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Elementor\Ajax_Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Ajax function for selecting one-time memberships
 *
 * @since 1.0.0
 */
function automatorwp_elementor_ajax_get_popups() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_admin', 'nonce' );

    $results = array();

    // Pull back the search string
    $search = isset( $_REQUEST['q'] ) ? sanitize_text_field( $_REQUEST['q'] ) : '';
    $page = isset( $_REQUEST['page'] ) ? absint( $_REQUEST['page'] ) : 1;

    $posts = get_posts( array(
        's'                 => $search,
        'post_type'         => 'elementor_library',
        'posts_per_page'    => 20,
        'page'              => $page,
        'post_status'       => 'publish',
        'meta_query'        => array(
            array(
                'key'       => '_elementor_template_type',
                'value'     => 'popup',
                'compare'   => '=',
            )
        )
    ) );

    foreach ( $posts as $post ) {

        // Results should meet Select2 structure
        $results[] = array(
            'id' => $post->ID,
            'text' => $post->post_title,
        );

    }

    // Prepend option none
    $results = automatorwp_ajax_parse_extra_options( $results );

    // Return our results
    wp_send_json_success( $results );
    die;

}
add_action( 'wp_ajax_automatorwp_elementor_get_popups', 'automatorwp_elementor_ajax_get_popups' );