<?php
/**
 * Show Popup
 *
 * @package     AutomatorWP\Integrations\Elementor\Actions\Show_Popup
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Elementor_Show_Popup extends AutomatorWP_Integration_Action {

    public $integration = 'elementor';
    public $action = 'elementor_show_popup';
    public $meta_key = 'automatorwp_elementor_popups';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Show a popup to the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Show a <strong>popup</strong> to the user', 'automatorwp-pro' ),
            /* translators: %1$s: Post title. */
            'edit_label'        => sprintf( __( 'Show %1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Post title. */
            'log_label'         => sprintf( __( 'Show %1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'post',
                    'name'              => __( 'Popup:', 'automatorwp-pro' ),
                    'option_default' => __( 'a popup', 'automatorwp-pro' ),
                    'option_none' => false,
                    'option_custom'         => true,
                    'option_custom_desc'    => __( 'Popup ID', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_elementor_get_popups',
                    'options_cb'        => 'automatorwp_options_cb_posts',
                    'default'           => 'any',
                ) ),
            ),
        ) );

    }

    /**
     * Register required hooks
     *
     * @since 1.0.0
     */
    public function hooks() {

        add_action( 'wp_footer', array( $this, 'maybe_load_popup' ), 10, 2 );

        parent::hooks();

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $post_id = absint( $action_options['post'] );

        $post = get_post( $post_id );

        // Bail if post doesn't exists
        if( ! $post ) {
            return;
        }

        // Get popups to show
        $popups_to_show = get_user_meta( $user_id, $this->meta_key, true );

        if( ! is_array( $popups_to_show ) ) {
            $popups_to_show = array();
        }

        $popups_to_show[] = $post_id;

        // Update popups to show
        update_user_meta( $user_id, $this->meta_key, $popups_to_show );

    }

    /**
     * Determine popups to load for this user
     *
     * @since 1.0.0
     */
    public function maybe_load_popup() {

        if( ! is_user_logged_in() ) {
            return;
        }

        $user_id = get_current_user_id();

        // Get popups to show
        $popups_to_show = get_user_meta( $user_id, $this->meta_key, true );

        if( ! is_array( $popups_to_show ) ) {
            $popups_to_show = array();
        }

        foreach( $popups_to_show as $popup_id ) :

            // Insert the popup to the current page
            ElementorPro\Modules\Popup\Module::add_popup_to_location( $popup_id ); ?>
            <script>
                jQuery(document).ready(function () {
                    // On load Elementor
                    jQuery(window).on('elementor/frontend/init', function () {
                        // On load Elementor components
                        elementorFrontend.on('components:init', function () {
                            // Show the popup
                            elementorFrontend.documentsManager.documents[<?php echo $popup_id;?>].showModal();
                        });
                    });
                });
            </script>
        <?php endforeach;

        // Reset the user meta
        delete_user_meta( $user_id, $this->meta_key );
    }

}

new AutomatorWP_Elementor_Show_Popup();