<?php
/**
 * User Purchased Download
 *
 * @package     AutomatorWP\Integrations\Easy_Digital_Downloads\Filters\User_Purchased_Download
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Easy_Digital_Downloads_User_Purchased_Download_Filter extends AutomatorWP_Integration_Filter {

    public $integration = 'easy_digital_downloads';
    public $filter = 'easy_digital_downloads_user_purchased_download';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_filter( $this->filter, array(
            'integration'       => $this->integration,
            'label'             => __( 'User has purchased', 'automatorwp-pro' ),
            'select_option'     => __( 'User has <strong>purchased</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Condition. %2$s: Download name. */
            'edit_label'        => sprintf( __( '%1$s', 'automatorwp-pro' ), '{post}' ),
            /* translators: %1$s: Condition. %2$s: Download name. */
            'log_label'         => sprintf( __( '%1$s', 'automatorwp-pro' ), '{post}' ),
            'options'           => array(
                'post' => automatorwp_utilities_post_option( array(
                    'name' => __( 'Download:', 'automatorwp-pro' ),
                    'option_none_label' => __( 'any download', 'automatorwp-pro' ),
                    'post_type' => 'download'
                ) ),
                'times' => automatorwp_utilities_times_option(),
            ),
        ) );

    }

    /**
     * User deserves check
     *
     * @since 1.0.0
     *
     * @param bool      $deserves_filter    True if user deserves filter, false otherwise
     * @param stdClass  $filter             The filter object
     * @param int       $user_id            The user ID
     * @param array     $event              Event information
     * @param array     $filter_options     The filter's stored options
     * @param stdClass  $automation         The trigger's automation object
     *
     * @return bool                          True if user deserves trigger, false otherwise
     */
    public function user_deserves_filter( $deserves_filter, $filter, $user_id, $event, $filter_options, $automation ) {

        // Shorthand
        $download_id = $filter_options['post'];

        // Bail if wrong configured
        if( empty( $download_id ) ) {
            $this->result = __( 'Filter not passed. Download option has not been configured.', 'automatorwp-pro' );
            return false;
        }

        $purchased = edd_has_user_purchased( $user_id, $download_id );

        // Don't deserve if user does not have purchased the download
        if( ! $purchased ) {
            $this->result = __( 'Filter not passed. User has not purchased the download.', 'automatorwp-pro' );

            return false;
        }

        $this->result =  __( 'Filter passed. User has purchased the download.', 'automatorwp-pro' );

        return $deserves_filter;

    }

}

new AutomatorWP_Easy_Digital_Downloads_User_Purchased_Download_Filter();