<?php
/**
 * Custom User Field Shortcode
 *
 * @package     AutomatorWP\Custom_User_Fields\Shortcodes\Custom_User_Field
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * [automatorwp_custom_user_field]
 *
 * @since 1.0.0
 *
 * @param array     $atts       Shortcode's attributes
 * @param string    $content    Shortcode's content
 *
 * @return string
 */
function automatorwp_custom_user_field_shortcode( $atts = array(), $content = '' ) {

    // Get the received shortcode attributes
    $atts = shortcode_atts( array(
        'field'         => '',
        'current_user'  => 'yes',
        'user_id'       => '0',
    ), $atts, 'automatorwp_custom_user_field' );

    // Force to set current user as user ID
    if( $atts['current_user'] === 'yes' ) {
        $atts['user_id'] = get_current_user_id();
    } else if( absint( $atts['user_id'] ) === 0 ) {
        $atts['user_id'] = get_current_user_id();
    }

    $output = get_user_meta( absint( $atts['user_id'] ), $atts['field'], true );

    /**
     * Filter to override shortcode output
     *
     * @since 1.0.0
     *
     * @param string    $output     Final output
     * @param array     $atts       Shortcode attributes
     * @param string    $content    Shortcode content
     */
    return apply_filters( 'automatorwp_custom_user_field_shortcode_output', $output, $atts, $content );

}
add_shortcode( 'automatorwp_custom_user_field', 'automatorwp_custom_user_field_shortcode' );
add_shortcode( 'awp_cuf', 'automatorwp_custom_user_field_shortcode' );