<?php
/**
 * Logs
 *
 * @package     AutomatorWP\Custom User Fields\Logs
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Get all custom user fields
 *
 * @since 1.0.0
 *
 *
 * @return array
 */
function automatorwp_custom_user_fields_get_all() {

    global $wpdb, $automatorwp_custom_user_fields_cache;

    if( ! $automatorwp_custom_user_fields_cache ) {

        // Setup table
        $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

        // Get all fields
        $automatorwp_custom_user_fields_cache = $wpdb->get_results( "SELECT * FROM {$ct_table->db->table_name} AS cuf" );

        ct_reset_setup_table();

    }

    return $automatorwp_custom_user_fields_cache;

}

/**
 * Get the count of all custom user fields
 *
 * @since 1.0.0
 *
 * @return int
 */
function automatorwp_custom_user_fields_get_count() {

    global $wpdb;

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

    $count = absint( $wpdb->get_var( "SELECT COUNT(*) FROM {$ct_table->db->table_name} AS cuf" ) );

    ct_reset_setup_table();

    return $count;

}

/**
 * Find custom user field that matches with a meta key
 *
 * @since 1.0.0
 *
 * @param int $trigger_id The trigger ID
 *
 * @return array
 */
function automatorwp_custom_user_fields_get_custom_field_by_meta_key( $meta_key ) {

    global $wpdb;

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

    // Search custom field by meta key
    $custom_field = $wpdb->get_row( $wpdb->prepare(
        "SELECT *
        FROM {$ct_table->db->table_name} AS cuf
        WHERE cuf.meta_key = %s",
        $meta_key,
    ) );

    ct_reset_setup_table();

    return $custom_field;

}

/**
 * Get the field title
 *
 * @since 1.0.0
 *
 * @param int $field_id
 *
 * @return string|null
 */
function automatorwp_custom_user_fields_get_meta_key_by_id( $field_id ) {

    global $wpdb;

    // Empty title if no ID provided
    if( absint( $field_id ) === 0 ) {
        return '';
    }

    // Setup table
    $ct_table = ct_setup_table( 'automatorwp_custom_user_fields' );

    // Search field by ID
    $field_name = $wpdb->get_var( $wpdb->prepare(
        "SELECT cuf.meta_key
        FROM {$ct_table->db->table_name} AS cuf
        WHERE cuf.id = %d",
        absint( $field_id ),
    ) );

    ct_reset_setup_table();

    return $field_name;

}