<?php
/**
 * Custom Tables
 *
 * @package     AutomatorWP\Custom_User_Fields\Custom_Tables
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

require_once AUTOMATORWP_CUSTOM_USER_FIELDS_DIR . 'includes/custom-tables/custom-user-fields.php';

/**
 * Register all custom database Tables
 *
 * @since   1.0.0
 *
 * @return void
 */
function automatorwp_custom_user_fields_register_custom_tables() {

    // Custom User Fields Logs
    ct_register_table( 'automatorwp_custom_user_fields', array(
        'singular' => __( 'Custom User Field', 'automatorwp-pro' ),
        'plural' => __( 'Custom User Fields', 'automatorwp-pro' ),
        'show_ui' => true,
        'show_in_rest' => true,
        'rest_base' => 'automatorwp-pro',
        'version' => 1,
        'capability' => automatorwp_get_manager_capability(),
        'supports' => array( 'meta' ),
        'views' => array(
            'list' => array(
                'menu_title' => __( 'Custom User Fields', 'automatorwp-pro' ),
                'parent_slug' => 'automatorwp',
            ),
        ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'name' => array(
                'type' => 'text',
            ),
            'meta_key' => array(
                'type' => 'text',
            ),
        ),
    ) );

}
add_action( 'ct_init', 'automatorwp_custom_user_fields_register_custom_tables' );