<?php
/**
 * Ajax Functions
 *
 * @package     AutomatorWP\Button\Ajax_Functions
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Button click listener
 *
 * @since 1.0.0
 */
function automatorwp_ajax_button_click() {
    // Security check, forces to die if not security passed
    check_ajax_referer( 'automatorwp_button', 'nonce' );

    // Bail if not trigger provided
    if( ! isset( $_POST['trigger'] ) ) {
        wp_send_json_error( __( 'Invalid trigger.', 'automatorwp-pro' ) );
    }

    // Setup vars
    $trigger_id = absint( $_POST['trigger'] );
    $id         = isset( $_POST['id'] )         ? sanitize_text_field( $_POST['id'] ) : '';
    $class      = isset( $_POST['class'] )      ? sanitize_text_field( $_POST['class'] ) : '';
    $post_id    = isset( $_POST['post_id'] )    ? absint( $_POST['post_id'] ) : 0;
    $user_id    = get_current_user_id();

    /**
     * Trigger button click action
     *
     * @since 1.0.0
     *
     * @param int       $trigger_id     The trigger ID
     * @param int       $user_id        The user ID
     * @param int       $post_id        The post ID
     * @param string    $id             The button id attribute
     * @param string    $class          The button class attribute
     */
    do_action( 'automatorwp_button_clicked', $trigger_id, $user_id, $post_id, $id, $class );

    wp_send_json_success( __( 'Done!', 'automatorwp-pro' ) );
    exit;
}
add_action( 'wp_ajax_automatorwp_button_click', 'automatorwp_ajax_button_click' );
