<?php
/**
 * Send Message
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Triggers\Send_Message
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Send_Message extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddypress';
    public $trigger = 'buddypress_send_message';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User sends or replies to a private message', 'automatorwp-pro' ),
            'select_option'     => __( 'User sends or replies to a <strong>private message</strong>', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User sends or replies to a private message %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User sends or replies to a private message', 'automatorwp-pro' ),
            'action'            => 'messages_message_sent',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 1,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param BP_Messages_Message $message
     */
    public function listener( $message ) {

        $user_id = $message->sender_id;

        // Trigger the send message
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_BuddyPress_Send_Message();