<?php
/**
 * Reject Friendship
 *
 * @package     AutomatorWP\Integrations\BuddyPress\Triggers\Reject_Friendship
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyPress_Reject_Friendship extends AutomatorWP_Integration_Trigger {

    public $integration = 'buddypress';
    public $trigger = 'buddypress_reject_friendship';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_trigger( $this->trigger, array(
            'integration'       => $this->integration,
            'label'             => __( 'User rejects a friendship request', 'automatorwp-pro' ),
            'select_option'     => __( 'User <strong>rejects a friendship</strong> request', 'automatorwp-pro' ),
            /* translators: %1$s: Number of times. */
            'edit_label'        => sprintf( __( 'User rejects a friendship request %1$s time(s)', 'automatorwp-pro' ), '{times}' ),
            'log_label'         => __( 'User rejects a friendship request', 'automatorwp-pro' ),
            'action'            => 'friends_friendship_rejected',
            'function'          => array( $this, 'listener' ),
            'priority'          => 10,
            'accepted_args'     => 2,
            'options'           => array(
                'times' => automatorwp_utilities_times_option(),
            ),
            'tags' => array_merge(
                automatorwp_utilities_times_tag()
            )
        ) );

    }

    /**
     * Trigger listener
     *
     * @since 1.0.0
     *
     * @param int $friendship_id
     * @param BP_Friends_Friendship $friendship
     */
    public function listener( $friendship_id, $friendship ) {

        $user_id = $friendship->friend_user_id;

        // Trigger the reject friendship
        automatorwp_trigger_event( array(
            'trigger'       => $this->trigger,
            'user_id'       => $user_id,
        ) );

    }

}

new AutomatorWP_BuddyPress_Reject_Friendship();