<?php
/**
 * Custom Tables
 *
 * @package     AutomatorWP\BuddyPress\Custom_Tables
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register all custom database Tables
 *
 * @since   1.0.0
 *
 * @return void
 */
function automatorwp_buddypress_register_custom_tables() {

    // Custom Data
    ct_register_table( 'automatorwp_buddypress_data', array(
        'singular' => __( 'BuddyPress Data', 'automatorwp-pro' ),
        'plural' => __( 'BuddyPress Data', 'automatorwp-pro' ),
        'show_ui' => false,
        'show_in_rest' => false,
        'version' => 1,
        'supports' => array( 'meta' ),
        'schema' => array(
            'id' => array(
                'type' => 'bigint',
                'length' => '20',
                'auto_increment' => true,
                'primary_key' => true,
            ),
            'object_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'user_id' => array(
                'type' => 'bigint',
                'length' => '20',
                'key' => true,
            ),
            'name' => array(
                'type' => 'varchar',
                'length' => 255,
                'nullable' => true,
                'default' => null,
                'key' => true
            ),
        ),
    ) );

}
add_action( 'ct_init', 'automatorwp_buddypress_register_custom_tables' );