<?php
/**
 * Unsuspend User
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Actions\Unsuspend_User
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Unsuspend_User extends AutomatorWP_Integration_Action {

    public $integration = 'buddyboss';
    public $action = 'buddyboss_unsuspend_user';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Unsuspend user', 'automatorwp-pro' ),
            'select_option'     => __( '<strong>Unsuspend</strong> user', 'automatorwp-pro' ),
            /* translators: %1$s: User. */
            'edit_label'        => sprintf( __( 'Unsuspend %1$s', 'automatorwp-pro' ), '{user}' ),
            /* translators: %1$s: User. */
            'log_label'         => sprintf( __( 'Unsuspend %1$s', 'automatorwp-pro' ), '{user}' ),
            'options'           => array(
                'user' => array(
                    'from' => 'user',
                    'default' => __( 'user', 'automatorwp-pro' ),
                    'fields' => array(
                        'user' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'User ID that will get unsuspended. Leave blank to unsuspend the user that completes the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        if( ! class_exists( 'BP_Suspend_Member' ) ) {
            return;
        }

        // Shorthand
        $user_id_to_unsuspend = absint( $action_options['user'] );

        if( $user_id_to_unsuspend === 0 ) {
            $user_id_to_unsuspend = $user_id;
        }

        // Unsuspend user
        BP_Suspend_Member::unsuspend_user( $user_id_to_unsuspend );

    }

}

new AutomatorWP_BuddyBoss_Unsuspend_User();