<?php
/**
 * Suspend User
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Actions\Suspend_User
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Suspend_User extends AutomatorWP_Integration_Action {

    public $integration = 'buddyboss';
    public $action = 'buddyboss_suspend_user';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Suspend user', 'automatorwp-pro' ),
            'select_option'     => __( '<strong>Suspend</strong> user', 'automatorwp-pro' ),
            /* translators: %1$s: User. */
            'edit_label'        => sprintf( __( 'Suspend %1$s', 'automatorwp-pro' ), '{user}' ),
            /* translators: %1$s: User. */
            'log_label'         => sprintf( __( 'Suspend %1$s', 'automatorwp-pro' ), '{user}' ),
            'options'           => array(
                'user' => array(
                    'from' => 'user',
                    'default' => __( 'user', 'automatorwp-pro' ),
                    'fields' => array(
                        'user' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'User ID that will get suspended. Leave blank to suspend the user that completes the automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                            'default' => ''
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        if( ! class_exists( 'BP_Suspend_Member' ) ) {
            return;
        }

        // Shorthand
        $user_id_to_suspend = absint( $action_options['user'] );

        if( $user_id_to_suspend === 0 ) {
            $user_id_to_suspend = $user_id;
        }

        // Suspend user
        BP_Suspend_Member::suspend_user( $user_id_to_suspend );

    }

}

new AutomatorWP_BuddyBoss_Suspend_User();