<?php
/**
 * Start/Stop Following User
 *
 * @package     AutomatorWP\Integrations\BuddyBoss\Actions\Following_User
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_BuddyBoss_Following_User extends AutomatorWP_Integration_Action {

    public $integration = 'buddyboss';
    public $action = 'buddyboss_following_user';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'User start or stop following a user', 'automatorwp-pro' ),
            'select_option'     => __( 'User start or stop <strong>following</strong> a user', 'automatorwp-pro' ),
            /* translators: %1$s: Group. */
            'edit_label'        => sprintf( __( '%1$s %2$s following a %3$s', 'automatorwp-pro' ), '{follower}', '{operation}', '{leader}' ),
            /* translators: %1$s: Group. */
            'log_label'         => sprintf( __( '%1$s %2$s following a %3$s', 'automatorwp-pro' ), '{follower}', '{operation}', '{leader}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'start'     => __( 'Start', 'automatorwp-pro' ),
                                'stop'    => __( 'Stop', 'automatorwp-pro' ),
                            ),
                            'default' => 'start'
                        ),
                    )
                ),
                'follower' => array(
                    'default' => __( 'Follower', 'automatorwp-pro' ),
                    'fields' => array(
                        'follower' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'The follower user ID. By default, ID of user who completes this automation.', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    ),
                ),
                'leader' => array(
                    'default' => __( 'leader', 'automatorwp-pro' ),
                    'fields' => array(
                        'leader' => array(
                            'name' => __( 'User ID:', 'automatorwp-pro' ),
                            'desc' => __( 'The user ID to start or stop to follow.', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    ),
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $operation = $action_options['operation'];
        $leader = $action_options['leader'];
        $follower = $action_options['follower'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'start';
        }

        // Ensure operation default value
        if( empty( $follower ) ) {
            $follower = $user_id;
        }

        // Setup the leader
        $leader = absint( $leader );

        // Setup the follower
        $follower = absint( $follower );

        // Bail if no correctly setup user to follow
        if( $leader === 0 ) {
            return;
        }

        // Bail if no correctly setup follower
        if( $follower === 0 ) {
            return;
        }

        // User can not follow himself
        if( $leader === $follower ) {
            return;
        }

        $args = array(
            'leader_id'   => $leader,
            'follower_id' => $follower,
        );

        switch( $operation ) {
            case 'start':
                if ( bp_is_active( 'follow' ) && function_exists( 'bp_follow_start_following' ) ) {
                    bp_follow_start_following( $args );
                } elseif ( function_exists( 'bp_start_following' ) ) {
                    bp_start_following( $args );
                }
                break;
            case 'stop':
                if ( bp_is_active( 'follow' ) && function_exists( 'bp_follow_stop_following' ) ) {
                    bp_follow_stop_following( $args );
                } elseif ( function_exists( 'bp_stop_following' ) ) {
                    bp_stop_following( $args );
                }
                break;
        }

    }

}

new AutomatorWP_BuddyBoss_Following_User();