<?php
/**
 * Plugin Name:           AutomatorWP - Blockli
 * Plugin URI:            https://automatorwp.com/add-ons/blockli/
 * Description:           Connect AutomatorWP with Blockli.
 * Version:               1.0.0
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-blockli
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.0
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\Blockli
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_Blockli {

    /**
     * @var         AutomatorWP_Blockli $instance The one true AutomatorWP_Blockli
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_Blockli self::$instance The one true AutomatorWP_Blockli
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_Blockli();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_BLOCKLI_VER', '1.0.0' );

        // Plugin file
        define( 'AUTOMATORWP_BLOCKLI_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_BLOCKLI_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_BLOCKLI_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Includes
            require_once AUTOMATORWP_BLOCKLI_DIR . 'includes/functions.php';

            // Actions
            require_once AUTOMATORWP_BLOCKLI_DIR . 'includes/actions/create-post-card.php';
            require_once AUTOMATORWP_BLOCKLI_DIR . 'includes/actions/create-video-card.php';
            require_once AUTOMATORWP_BLOCKLI_DIR . 'includes/actions/create-graphic-card.php';
            require_once AUTOMATORWP_BLOCKLI_DIR . 'includes/actions/create-featured-card.php';            
            
        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'blockli', array(
            'label' => 'Blockli',
            'icon'  => AUTOMATORWP_BLOCKLI_URL . 'assets/blockli.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! defined( 'BLOCKLI_PLUGIN' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_Blockli instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_Blockli The one true AutomatorWP_Blockli
 */
function AutomatorWP_Blockli() {
    return AutomatorWP_Blockli::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_Blockli' );
