<?php
/**
 * Plugin Name:           AutomatorWP - bbPress
 * Plugin URI:            https://automatorwp.com/add-ons/bbpress/
 * Description:           Connect AutomatorWP with bbPress.
 * Version:               1.0.6
 * Author:                AutomatorWP
 * Author URI:            https://automatorwp.com/
 * Text Domain:           automatorwp-bbpress
 * Domain Path:           /languages/
 * Requires at least:     4.4
 * Tested up to:          6.0
 * License:               GNU AGPL v3.0 (http://www.gnu.org/licenses/agpl.txt)
 *
 * @package               AutomatorWP\bbPress
 * @author                AutomatorWP
 * @copyright             Copyright (c) AutomatorWP
 */

final class AutomatorWP_bbPress {

    /**
     * @var         AutomatorWP_bbPress $instance The one true AutomatorWP_bbPress
     * @since       1.0.0
     */
    private static $instance;

    /**
     * Get active instance
     *
     * @access      public
     * @since       1.0.0
     * @return      AutomatorWP_bbPress self::$instance The one true AutomatorWP_bbPress
     */
    public static function instance() {
        if( !self::$instance ) {
            self::$instance = new AutomatorWP_bbPress();
            self::$instance->constants();
            self::$instance->includes();
            self::$instance->hooks();            
        }

        return self::$instance;
    }

    /**
     * Setup plugin constants
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function constants() {
        // Plugin version
        define( 'AUTOMATORWP_BBPRESS_VER', '1.0.6' );

        // Plugin file
        define( 'AUTOMATORWP_BBPRESS_FILE', __FILE__ );

        // Plugin path
        define( 'AUTOMATORWP_BBPRESS_DIR', plugin_dir_path( __FILE__ ) );

        // Plugin URL
        define( 'AUTOMATORWP_BBPRESS_URL', plugin_dir_url( __FILE__ ) );
    }

    /**
     * Include plugin files
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function includes() {

        if( $this->meets_requirements() ) {

            // Triggers
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/create-forum.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/create-topic.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/create-reply.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/get-reply.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/favorite-topic.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/unfavorite-topic.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/triggers/get-favorite.php';

            // Actions
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/actions/subscribe-user-forum.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/actions/unsubscribe-user-forum.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/actions/create-new-topic.php';
            require_once AUTOMATORWP_BBPRESS_DIR . 'includes/actions/create-new-reply.php';

        }
    }

    /**
     * Setup plugin hooks
     *
     * @access      private
     * @since       1.0.0
     * @return      void
     */
    private function hooks() {

        add_action( 'automatorwp_init', array( $this, 'register_integration' ) );
        
        // Setup our activation and deactivation hooks
        register_activation_hook( __FILE__, array( $this, 'activate' ) );
        register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );
        

        
    }

    /**
     * Registers this integration
     *
     * @since 1.0.0
     */
    function register_integration() {

        automatorwp_register_integration( 'bbpress', array(
            'label' => 'bbPress',
            'icon'  => AUTOMATORWP_BBPRESS_URL . 'assets/bbpress.svg',
        ) );

    }

    /**
     * Activation hook for the plugin.
     *
     * @since  1.0.0
     */
    function activate() {

        if( $this->meets_requirements() ) {

        }

    }

    /**
     * Deactivation hook for the plugin.
     *
     * @since  1.0.0
     */
    function deactivate() {

    }

    /**
     * Check if there are all plugin requirements
     *
     * @since  1.0.0
     *
     * @return bool True if installation meets all requirements
     */
    private function meets_requirements() {

        if ( ! class_exists( 'AutomatorWP' ) ) {
            return false;
        }

        if ( ! class_exists( 'bbPress' ) ) {
            return false;
        }

        return true;

    }

}

/**
 * The main function responsible for returning the one true AutomatorWP_bbPress instance to functions everywhere
 *
 * @since       1.0.0
 * @return      \AutomatorWP_bbPress The one true AutomatorWP_bbPress
 */
function AutomatorWP_bbPress() {
    return AutomatorWP_bbPress::instance();
}
add_action( 'plugins_loaded', 'AutomatorWP_bbPress' );
